import SGE.*;

public class Landschaft
{
    private SGLeinwand meineLeinwand;
    private SGRechteck boden;
    private SGRechteck haus;
    private SGRechteck schornstein;
    private SGRechteck baumstamm;
    private SGDreieck hausdach;
    private SGKreis baumkrone;
    private SGKreis sonne;
    private SGKreis wolke1, wolke2;    
    private SGRechteck mast, rotor1, rotor2;

    private SGTastatur tasti;
    private SGMaus mausi;
    /**
     * Konstruktor fuer Objekte der Klasse Anwendung
     */
    public Landschaft()
    {

        meineLeinwand = new SGLeinwand(500,500);
        meineLeinwand.setzeHintergrundfarbe(0, 0.8, 1.0);

        sonne = new SGKreis(380,30,40);
        sonne.setzeFuellung(true);
        sonne.setzeFarbe(1.0,1.0,0.0);

        boden = new SGRechteck(0,400,500,100);
        boden.setzeFuellung(true);
        boden.setzeFarbe(0,0.8,0.25);

        haus = new SGRechteck(160,350,50,50);
        haus.setzeFuellung(true);
        haus.setzeFarbe(0,0.2,0.8);

        schornstein = new SGRechteck(165,310,10,25);
        schornstein.setzeFuellung(true);
        schornstein.setzeFarbe(0,0.2,0.8);

        hausdach = new SGDreieck(150,350,220,350,185,305);
        hausdach.setzeFuellung(true);
        hausdach.setzeFarbe(1.0,0.6,0.2);
        hausdach.setzeEbene(2);

        baumstamm = new SGRechteck(45,350,10,50);
        baumstamm.setzeFarbe(0.6,0.4,0);
        baumstamm.setzeFuellung(true);

        baumkrone = new SGKreis(20,295,30);
        baumkrone.setzeFuellung(true);
        baumkrone.setzeFarbe(0,0.6,0);
        baumkrone.setzeEbene(2);

        wolke1 = new SGKreis(80,120,30);
        wolke1.setzeFuellung(true);
        wolke1.setzeFarbe(1.0,1.0,1.0);

        wolke2 = new SGKreis(125,130,30);
        wolke2.setzeFuellung(true);
        wolke2.setzeFarbe(1.0,1.0,1.0);

        mast = new SGRechteck(375,300,10,100);
        mast.setzeFuellung(true);
        mast.setzeFarbe(1,1,1);
        mast.setzeEbene(2);

        rotor1 = new SGRechteck(330,295,100,10);
        rotor1.setzeFuellung(true);
        rotor1.setzeFarbe(1,0,0);
        rotor1.setzeEbene(3);
        rotor1.dreheUmMittelpunkt(-45);

        rotor2 = new SGRechteck(330,295,100,10);
        rotor2.setzeFuellung(true);
        rotor2.setzeFarbe(1,0,0);
        rotor2.setzeEbene(3);
        rotor2.dreheUmMittelpunkt(45);

        tasti = new SGTastatur();
        mausi = new SGMaus();
    }

    public void animiere()
    {

        while( tasti.esc() == false ) {

            wolke1.verschiebe(0.5,0);
            wolke2.verschiebe(0.5,0);

            if( tasti.rechts() == true ) {
                rotor1.dreheUmMittelpunkt(1);
                rotor2.dreheUmMittelpunkt(1);
            }

            SGSystem.warte();
        }

    }
}
